///////////////////////////////////////////////////////////////////////
//
//  KOOGLE - Quake II Bot Base Code
//
//  Version 1.0
//
//  This file is Copyright(c), Steve Yeager 1998, All Rights Reserved
//
//
//	All other files are Copyright(c) Id Software, Inc.
//
//	Please see liscense.txt in the source directory for the copyright
//	information regarding those files belonging to Id Software, Inc.
//	
//	Should you decide to release a modified version of KOOGLE, you MUST
//	include the following text (minus the BEGIN and END lines) in the 
//	documentation for your modification.
//
//	--- BEGIN ---
//
//	The KOOGLE Bot is a product of Steve Yeager, and is available from
//	the KOOGLE Bot homepage, at http://www.axionfx.com/ace.
//
//	This program is a modification of the KOOGLE Bot, and is therefore
//	in NO WAY supported by Steve Yeager.

//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Steve Yeager immediately, via
//	the KOOGLE Bot homepage.
//
//	--- END ---
//
//	I, Steve Yeager, hold no responsibility for any harm caused by the
//	use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
//
//  I also wish to thank and acknowledge the great work of others
//  that has helped me to develop this code.
//
//  John Cricket    - For ideas and swapping code.
//  Ryan Feltrin    - For ideas and swapping code.
//  SABIN           - For showing how to do true client based movement.
//  BotEpidemic     - For keeping us up to date.
//  Telefragged.com - For giving KOOGLE a home.
//  Microsoft       - For giving us such a wonderful crash free OS.
//  id              - Need I say more.
//  
//  And to all the other testers, pathers, and players and people
//  who I can't remember who the heck they were, but helped out.
//
///////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////
//
//  acebot_spawn.c - This file contains all of the 
//                   spawing support routines for the KOOGLE bot.
//
///////////////////////////////////////////////////////////////////////

#include "g_local.h"
#include "m_player.h"

///////////////////////////////////////////////////////////////////////
// Had to add this function in this version for some reason.
// any globals are wiped out between level changes....so
// save the bots out to a file. 
//
// NOTE: There is still a bug when the bots are saved for
//       a dm game and then reloaded into a CTF game.
///////////////////////////////////////////////////////////////////////
void KOOGLESP_SaveBots()
{
    edict_t *bot;
    FILE *pOut;
	int i,count = 0;
    char filename[60];
    cvar_t  *game_dir;	

    game_dir = gi.cvar ("game", "", 0);
/*
	if((pOut = fopen("ace\\bots.tmp", "wb" )) == NULL)
		return; // bail
*/
    i =  sprintf(filename, "."DIR_SLASH"");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, ""DIR_SLASH"kooglebot"DIR_SLASH"");
    i += sprintf(filename + i, ""DIR_SLASH"bots"DIR_SLASH"");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, "_bots.tmp"); // change file extension here

	if((pOut = fopen(filename, "wb" )) == NULL)
    {
		// Create item table
		safe_bprintf(PRINT_MEDIUM, "KOOGLE: No bot loader found for %s.bsp, bailing!\n",level.mapname);
		return; 
	}
	
	// Get number of bots
	for (i = maxclients->value; i > 0; i--)
	{
		bot = g_edicts + i + 1;

		if (bot->inuse && bot->is_bot)
			count++;
	}
	
	fwrite(&count,sizeof (int),1,pOut); // Write number of bots

	for (i = maxclients->value; i > 0; i--)
	{
		bot = g_edicts + i + 1;

		if (bot->inuse && bot->is_bot)
			fwrite(bot->client->pers.userinfo,sizeof (char) * MAX_INFO_STRING,1,pOut); 
	}
		
    fclose(pOut);
}

///////////////////////////////////////////////////////////////////////
// Had to add this function in this version for some reason.
// any globals are wiped out between level changes....so
// load the bots from a file.
//
// Side effect/benifit are that the bots persist between games.
///////////////////////////////////////////////////////////////////////
void KOOGLESP_LoadBots()
{
    FILE *pIn;
	char userinfo[MAX_INFO_STRING];
	int i, count;
    char filename[60];
    cvar_t  *game_dir;

    game_dir = gi.cvar ("game", "", 0);
/*
	if((pIn = fopen("ace\\bots.tmp", "rb" )) == NULL)
		return; // bail
*/
	
    i =  sprintf(filename, "."DIR_SLASH"");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, ""DIR_SLASH"kooglebot"DIR_SLASH"");
    i += sprintf(filename + i, ""DIR_SLASH"bots"DIR_SLASH"");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, "_bots.tmp"); // change file extension here

	if((pIn = fopen(filename, "rb" )) == NULL)
    {
		// Create item table
		safe_bprintf(PRINT_MEDIUM, "KOOGLE: No bot loader found for %s.bsp, bailing!\n",level.mapname);
		return; 
	}

	fread(&count,sizeof (int),1,pIn); 

	for(i=0;i<count;i++)
	{
		fread(userinfo,sizeof(char) * MAX_INFO_STRING,1,pIn); 
		KOOGLESP_SpawnBot (NULL, NULL, NULL, userinfo);
	}
		
    fclose(pIn);
}

///////////////////////////////////////////////////////////////////////
// Called by PutClient in Server to actually release the bot into the game
// Keep from killin' each other when all spawned at once
///////////////////////////////////////////////////////////////////////
void KOOGLESP_HoldSpawn(edict_t *self)
{
	if (!KillBox (self))
	{	// could't spawn in?
	}

	gi.linkentity (self);

	self->think = KOOGLEAI_Think;
	self->nextthink = level.time + FRAMETIME;

	// send effect
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (self-g_edicts);
	gi.WriteByte (MZ_LOGIN);
	gi.multicast (self->s.origin, MULTICAST_PVS);

/*	if(ctf->value)
	safe_bprintf(PRINT_MEDIUM, "%s joined the %s team.\n",
		self->client->pers.netname, CTFTeamName(self->client->resp.ctf_team));
	else*/
		safe_bprintf (PRINT_MEDIUM, "%s is once again in the House!!\n", self->client->pers.netname);

}

///////////////////////////////////////////////////////////////////////
// Modified version of id's code
///////////////////////////////////////////////////////////////////////
void KOOGLESP_PutClientInServer (edict_t *bot, qboolean respawn, int team)
{
	vec3_t	mins = {-16, -16, -24};
	vec3_t	maxs = {16, 16, 32};
	int		index;
	vec3_t	spawn_origin, spawn_angles;
	gclient_t	*client;
	int		i;
	client_persistant_t	saved;
	client_respawn_t	resp;
//	char *s;
	
	// find a spawn point
	// do it before setting health back up, so farthest
	// ranging doesn't count this client
	SelectSpawnPoint (bot, spawn_origin, spawn_angles);
	
	index = bot-g_edicts-1;
	client = bot->client;

	// deathmatch wipes most client data every spawn
	if (deathmatch->value)
	{
		char userinfo[MAX_INFO_STRING];

		resp = bot->client->resp;
		memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
		InitClientPersistant (client);
		ClientUserinfoChanged (bot, userinfo);
	}
	else
		memset (&resp, 0, sizeof(resp));

	//make sure we take a user slot for ourself
	bot->name_index = -1;

	// clear everything but the persistant data
	saved = client->pers;
	memset (client, 0, sizeof(*client));
	client->pers = saved;
	if( client->pers.health <=0 )
	InitClientPersistant( client);
	client->resp = resp;
	
	// copy some data from the client to the entity
	FetchClientEntData (bot);
	
	// clear entity values
	bot->groundentity = NULL;
	bot->client = &game.clients[index];
	bot->takedamage = DAMAGE_AIM;
    
	ROUNDCONTROLBOT
    //we no longer do these things from here
	//we call this shit from KOOGLESET_SetupRound(); (at bottom of this page)
    ROUNDCONTROLELSE
	//this mother  fucker is not going anywhere until the round starts G
	bot->movetype = MOVETYPE_WALK;
	bot->solid = SOLID_BBOX;
	bot->svflags &= ~(SVF_DEADMONSTER|SVF_NOCLIENT);
	//gi.dprintf("\n%s is Now In Walk Mode From KOOGLESP_PutClientInServer\n",bot->client->pers.netname);
    ROUNDCONTROLEND

	bot->viewheight = 40;
	bot->inuse = true;
	bot->classname = "bot";
	bot->mass = 200;
	bot->deadflag = DEAD_NO;
	bot->air_finished = level.time + 12;
	bot->clipmask = MASK_PLAYERSOLID;
	bot->pain = player_pain;
	bot->die = player_die;
	bot->waterlevel = 0;
	bot->watertype = 0;
	bot->flags &= ~FL_NO_KNOCKBACK;
	bot->is_jumping = false;
	bot->s.renderfx2 = 0;
	bot->onfiretime = 0;
	// make AI run towards us if in pursuit
	bot->cast_info.aiflags |= AI_GOAL_RUN;	

	VectorCopy (mins, bot->mins);
	VectorCopy (maxs, bot->maxs);
	VectorClear (bot->velocity);

	bot->cast_info.standing_max_z = bot->maxs[2];
	bot->cast_info.scale = MODEL_SCALE;
	bot->s.scale = bot->cast_info.scale - 1.0;

	// clear playerstate values
	memset (&bot->client->ps, 0, sizeof(client->ps));
	
	client->ps.pmove.origin[0] = spawn_origin[0]*8;
	client->ps.pmove.origin[1] = spawn_origin[1]*8;
	client->ps.pmove.origin[2] = spawn_origin[2]*8;

	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		client->ps.fov = 90;
	}
	else
	{
		client->ps.fov = atoi(Info_ValueForKey(client->pers.userinfo, "fov"));
		if (client->ps.fov < 1)
			client->ps.fov = 90;
		else if (client->ps.fov > 160)
			client->ps.fov = 160;
	}

	// weapon mdx
	{
		int i;
	
		memset(&(client->ps.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);

		client->ps.num_parts++;

		if (client->pers.weapon)
			client->ps.model_parts[PART_HEAD].modelindex = gi.modelindex(client->pers.weapon->view_model);
		
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			client->ps.model_parts[PART_HEAD].skinnum[i] = 0; // will we have more than one skin???
	}

	if (client->pers.weapon)
		client->ps.gunindex = gi.modelindex(client->pers.weapon->view_model);

	// clear entity state values
	bot->s.effects = 0;
	bot->s.skinnum = bot - g_edicts - 1;
	// will use the skin specified model
	bot->s.modelindex = 255;		
	bot->s.frame = 0;
	VectorCopy (spawn_origin, bot->s.origin);
	// make sure off ground
	bot->s.origin[2] += 1;	

	VectorCopy (bot->s.origin, bot->s.old_origin);

	// bikestuff
	bot->biketime = 0;
	bot->bikestate = 0;

    // Ridah, Hovercars
	if (g_vehicle_test->value)
	{
		if (g_vehicle_test->value == 3)
			bot->s.modelindex = gi.modelindex ("models/props/moto/moto.mdx");
		else
			bot->s.modelindex = gi.modelindex ("models/vehicles/cars/viper/tris_test.md2");

		bot->s.skinnum = 0;
		bot->s.frame = 0;

		if ((int)g_vehicle_test->value == 1)
			bot->flags |= FL_HOVERCAR_GROUND;
		else if ((int)g_vehicle_test->value == 2)
			bot->flags |= FL_HOVERCAR;
		else if ((int)g_vehicle_test->value == 3)
			bot->flags |= FL_BIKE;
		else if ((int)g_vehicle_test->value == 4)
			bot->flags |= FL_CAR;
	}
	// deathmatch, note models must exist on server for client's to use them, 
	// but if the server has a model a client doesn't that client will see the default male model
	else if (dm_locational_damage->value)	
	{
		char	*s;
		char	modeldir[MAX_QPATH];//, *skins;
		int		len;
		int		did_slash;
		char	modelname[MAX_QPATH];

		// NOTE: this is just here for collision detection, modelindex's aren't actually set


		// so the client's setup the model for viewing
		bot->s.num_parts = 0;		

		s = Info_ValueForKey (client->pers.userinfo, "skin");

		// converts some characters to NULL's
		len = strlen( s );
		did_slash = 0;

		for (i=0; i<len; i++)
		{
			if (s[i] == '/')
			{
				s[i] = '\0';
				did_slash = true;
			}
			else if (s[i] == ' ' && did_slash)
			{
				s[i] = '\0';
			}
		}

		if (strlen(s) > MAX_QPATH-1)
			s[MAX_QPATH-1] = '\0';

		strcpy(modeldir, s);
		
		if (strlen(modeldir) < 1)
		strcpy( modeldir, "male_thug" );
		
		memset(&(bot->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
		
		bot->s.num_parts++;
		strcpy( modelname, "players/" );
		strcat( modelname, modeldir );
		strcat( modelname, "/head.mdx" );
		bot->s.model_parts[bot->s.num_parts-1].modelindex = 255;
		gi.GetObjectBounds( modelname, &bot->s.model_parts[bot->s.num_parts-1] );
		
		//get the mother fuckers head
		if (!bot->s.model_parts[bot->s.num_parts-1].object_bounds[0])
		gi.GetObjectBounds( "players/male_thug/head.mdx", &bot->s.model_parts[bot->s.num_parts-1] );

		bot->s.num_parts++;
		strcpy( modelname, "players/" );
		strcat( modelname, modeldir );
		strcat( modelname, "/legs.mdx" );
		bot->s.model_parts[bot->s.num_parts-1].modelindex = 255;
		gi.GetObjectBounds( modelname, &bot->s.model_parts[bot->s.num_parts-1] );
		
		//get the mother fuckers legs
		if (!bot->s.model_parts[bot->s.num_parts-1].object_bounds[0])
		gi.GetObjectBounds( "players/male_thug/legs.mdx", &bot->s.model_parts[bot->s.num_parts-1] );

		bot->s.num_parts++;
		strcpy( modelname, "players/" );
		strcat( modelname, modeldir );
		strcat( modelname, "/body.mdx" );
		bot->s.model_parts[bot->s.num_parts-1].modelindex = 255;
		gi.GetObjectBounds( modelname, &bot->s.model_parts[bot->s.num_parts-1] );
		
		//get the mother fuckers body
		if (!bot->s.model_parts[bot->s.num_parts-1].object_bounds[0])
		gi.GetObjectBounds( "players/male_thug/body.mdx", &bot->s.model_parts[bot->s.num_parts-1] );

		bot->s.num_parts++;
		bot->s.model_parts[PART_GUN].modelindex = 255;
	}
	else	
	{
		// make sure we can see their fuckn weapon
		memset(&(bot->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
		bot->s.model_parts[PART_GUN].modelindex = 255;

		// make sure old clients recieve the godamn view weapon index
		bot->s.num_parts = PART_GUN+1;	
	}

	// set the delta angle
	for (i=0 ; i<3 ; i++)
		client->ps.pmove.delta_angles[i] = ANGLE2SHORT(spawn_angles[i] - client->resp.cmd_angles[i]);

	bot->s.angles[PITCH] = 0;
	bot->s.angles[YAW] = spawn_angles[YAW];
	bot->s.angles[ROLL] = 0;
	VectorCopy (bot->s.angles, client->ps.viewangles);
	VectorCopy (bot->s.angles, client->v_angle);
	
	// force the current fuckn weapon up
	client->newweapon = client->pers.weapon;
	ChangeWeapon (bot);

	bot->enemy = NULL;
	bot->movetarget = NULL; 
	
	ROUNDCONTROLBOT
	//hold still while your in chase mode mother fucker
	bot->state = BOTSTATE_STAND;
	ROUNDCONTROLELSE
    //round started so now u can walk asshole
	bot->state = BOTSTATE_MOVE;
    ROUNDCONTROLEND
		
	// Set the current node
	bot->current_node = KOOGLEND_FindClosestReachableNode(bot,BOTNODE_DENSITY, BOTNODE_ALL);
	bot->goal_node = bot->current_node;
	bot->next_node = bot->current_node;
	bot->next_move_time = level.time;		
	bot->suicide_timeout = level.time + 15.0;
	bot->ghost_timeout = level.time + 15.0;
    
	if (level.num_botloads == 0) 
	level.num_botloads = 1;
	else
	level.num_botloads++;


	// If we are not respawning hold off for up to five seconds before releasing into game
    if(!respawn)
	{
		bot->think = KOOGLESP_HoldSpawn;
		bot->nextthink = level.time + 0.10;
		bot->nextthink = level.time + random()*5.0; // up to three seconds
	}
	else
	{
		if (!KillBox (bot))
		{	// could't spawn in?
		}

		gi.linkentity (bot);

		bot->think = KOOGLEAI_Think;
		bot->nextthink = level.time + FRAMETIME;
	}
	
}

///////////////////////////////////////////////////////////////////////
// Respawn the bot
///////////////////////////////////////////////////////////////////////
void KOOGLESP_Respawn (edict_t *self)
{
	CopyToBodyQue (self);

	//put that bastard back in the server
	KOOGLESP_PutClientInServer (self,true,0);

	// add a teleportation effect
	self->s.event = EV_PLAYER_TELEPORT;

		// hold in place briefly
	self->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
	self->client->ps.pmove.pm_time = 14;
 	self->client->respawn_time = level.time;
	
}

///////////////////////////////////////////////////////////////////////
// Find a free client spot
///////////////////////////////////////////////////////////////////////
edict_t *KOOGLESP_FindFreeClient (void)
{
	edict_t *bot;
	int	i;
	int max_count=0;
	
	// This is for the naming of the bots
	for (i = maxclients->value; i > 0; i--)
	{
		bot = g_edicts + i + 1;
		
		if(bot->count > max_count)
			max_count = bot->count;
	}

	// Check for free spot
	for (i = maxclients->value; i > 0; i--)
	{
		bot = g_edicts + i + 1;

		if (!bot->inuse)
			break;
	}

	// Will become bot name...
	bot->count = max_count + 1; 

	if (bot->inuse)
		bot = NULL;
	
	return bot;
}

///////////////////////////////////////////////////////////////////////
// Set the name of the bot and update the userinfo
///////////////////////////////////////////////////////////////////////
void KOOGLESP_SetName(edict_t *bot, char *name, char *skin, char *team)
{
	float rnd;
	char userinfo[MAX_INFO_STRING];
	char bot_skin[MAX_INFO_STRING];
	char bot_name[MAX_INFO_STRING];

	// Set the name for the bot.
	if(strlen(name) == 0)
		sprintf(bot_name,"KoogleBot_%d",bot->count);
	else
		strcpy(bot_name,name);
	
	// skin
	if(strlen(skin) == 0)
	{
		// randomly choose skin 
		rnd = random();
		if(rnd  < 0.05)
			sprintf(bot_skin,"female_chick/005 005 005");
		else if(rnd < 0.1)
			sprintf(bot_skin,"male_thug/010 010 010");
		else if(rnd < 0.15)
			sprintf(bot_skin,"male_thug/011 011 011");
		else if(rnd < 0.2)
			sprintf(bot_skin,"male_thug/012 012 012");
		else if(rnd < 0.25)
			sprintf(bot_skin,"female_chick/006 006 006");
		else if(rnd < 0.3)
			sprintf(bot_skin,"male_thug/013 013 013");
		else if(rnd < 0.35)
			sprintf(bot_skin,"male_thug/013 013 013");
		else if(rnd < 0.4)
			sprintf(bot_skin,"female_chick/020 020 020");
		else if(rnd < 0.45)
			sprintf(bot_skin,"male_thug/014 014 014");
		else if(rnd < 0.5)
			sprintf(bot_skin,"male_thug/015 015 015");
		else if(rnd < 0.55)
			sprintf(bot_skin,"male_thug/016 016 016");
		else if(rnd < 0.6)
			sprintf(bot_skin,"male_thug/017 017 017");
		else if(rnd < 0.65)
			sprintf(bot_skin,"female_chick/056 056 056");
		else if(rnd < 0.7)
			sprintf(bot_skin,"male_thug/300 300 300");
		else if(rnd < 0.75)
			sprintf(bot_skin,"male_thug/010 010 010");
		else if(rnd < 0.8)
			sprintf(bot_skin,"male_thug/008 008 008");
		else if(rnd < 0.85)
			sprintf(bot_skin,"male_thug/009 019 017");
		else if(rnd < 0.9)
			sprintf(bot_skin,"female_chick/032 032 032");
		else if(rnd < 0.95)
			sprintf(bot_skin,"male_thug/001 001 001");
		else 
			sprintf(bot_skin,"male_thug/004 004 004");
	}
	else
		strcpy(bot_skin,skin);

	// initialise userinfo
	memset (userinfo, 0, sizeof(userinfo));

	// add bot's name/skin/hand to userinfo
	Info_SetValueForKey (userinfo, "name", bot_name);
	Info_SetValueForKey (userinfo, "skin", bot_skin);
	
	// bot is center handed for now!
	Info_SetValueForKey (userinfo, "hand", "2"); 

	ClientConnect (bot, userinfo);

	// make sure to save the bots
	KOOGLESP_SaveBots(); 
}

///////////////////////////////////////////////////////////////////////
// Spawn the bot
///////////////////////////////////////////////////////////////////////
void KOOGLESP_SpawnBot (char *team, char *name, char *skin, char *userinfo)
{
	edict_t	*bot;
	
	bot = KOOGLESP_FindFreeClient ();
	
	if (!bot)
	{
		safe_bprintf (PRINT_MEDIUM, "Server is full, increase Maxclients.\n");
		return;
	}
    
	// yaw speed
	bot->yaw_speed = 100; 
	bot->inuse = true;
	bot->is_bot = true;

	// To allow bots to respawn
	if(userinfo == NULL)
		KOOGLESP_SetName(bot, name, skin, team);
	else
		ClientConnect (bot, userinfo);
	
	G_InitEdict (bot);

	InitClientResp (bot->client);

	KOOGLESP_PutClientInServer (bot,false,0);

	// make sure all view stuff is valid
	ClientEndServerFrame (bot);
	
	// let the world know we added another
	KOOGLEIT_PlayerAdded (bot); 

	// pick a new goal
	KOOGLEAI_PickLongRangeGoal(bot); 

}

///////////////////////////////////////////////////////////////////////
// Remove a bot by name or all bots
///////////////////////////////////////////////////////////////////////
void KOOGLESP_RemoveBot(char *name)
{
	int i;
	qboolean freed=false;
	edict_t *bot;

	for(i=0;i<maxclients->value;i++)
	{
		bot = g_edicts + i + 1;
		if(bot->inuse)
		{
			if(bot->is_bot && (Q_stricmp(bot->client->pers.netname,name)==0 || Q_stricmp(name,"all")==0))
			{
				bot->health = 0;
				player_die (bot, bot, bot, 1, vec3_origin,0,0);
				
				// don't even bother waiting for death frames
				bot->deadflag = DEAD_DEAD;
				
				bot->inuse = false;
				freed = true;
				KOOGLEIT_PlayerRemoved (bot);
				safe_bprintf (PRINT_MEDIUM, "%s removed\n", bot->client->pers.netname);
			}
		}
	}

	if(!freed)	
		safe_bprintf (PRINT_MEDIUM, "%s not found\n", name);
	
	// Save them again
	KOOGLESP_SaveBots(); 
}


///////////////////////////////////////////////////////////////////////
// Make The Bots Behave During Map Change and MatchSetup
///////////////////////////////////////////////////////////////////////
void KOOGLESET_SetupRound()
{
	int i;
	edict_t *self;

	//this is where i force these litle fuckers to stop crashing the server
    //they always are in some kind of anxious hurry to kill something and often
    //there fucking impatient asses seem to cause the server to crash. So
	//we take their shit away and make them stand still during map vot and map change!

    for_each_bot (self,i)
	{
	   self->groundentity = NULL;
	   self->movetype = MOVETYPE_NOCLIP;
	   self->solid = SOLID_NOT;
	   self->svflags |= SVF_NOCLIENT;
	   self->client->pers.weapon = NULL;
	   self->client->pers.spectator = SPECTATING;
	   gi.dprintf("\n%s Has Moved To Spectate Mode\n",self->client->pers.netname);

	}

    



	/*
	for(i=0;i<maxclients->value;i++)
	{
		bot = g_edicts + i + 1;
		
		if(bot->inuse)
		{
			if((bot->is_bot) && (!bot->client->pers.spectator == SPECTATING))
			{
				bot->health = 0;
			//	player_die (bot, bot, bot, 1, vec3_origin,0,0);
   	            bot->client->buttons = 0;
		        bot->client->pers.bagcash = 0;
		        bot->client->resp.deposited = 0;
		        bot->client->resp.botkills = 0;
                bot->client->resp.mynumber = 0;
		        bot->client->resp.score = 0;
		        bot->client->pers.currentcash = 0;
		        bot->client->resp.acchit = bot->client->resp.accshot = 0;

		        memset(bot->client->resp.fav,0,15*sizeof(int));
		        
				bot->movetype = MOVETYPE_NOCLIP;
		        bot->solid = SOLID_NOT;
		        bot->svflags |= SVF_NOCLIENT;
		        bot->client->pers.weapon = NULL;
		        bot->client->pers.spectator = SPECTATING;
		        //gi.dprintf("\n%s Has Moved To Spectate Mode\n",bot->client->pers.netname);
				bot->client->resp.is_spawn = false;

			}
		}
	}
	
	  */
}